/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.EntityDetector;

import com.samsthenerd.duckyperiphs.peripherals.EntityDetector.EntityDetectorTile;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;

public class EntityDetectorPeripheral
implements IPeripheral {
    public static int DEFAULT_RANGE = 8;
    public static int DEFAULT_Y_RANGE = 16;
    private final EntityDetectorTile edTile;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    EntityDetectorPeripheral(EntityDetectorTile edPTile) {
        this.edTile = edPTile;
    }

    @Nonnull
    public String getType() {
        return "entity_detector";
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final Map<String, Object>[] nearbyEntities() {
        class_238 rangeBox = this.edTile.makeBox(DEFAULT_RANGE, DEFAULT_Y_RANGE);
        List<class_1297> entities = this.edTile.nearbyEntities(rangeBox);
        Map[] entityMaps = new Map[entities.size()];
        class_2338 edPos = this.edTile.method_11016();
        for (int e = 0; e < entities.size(); ++e) {
            class_1297 entity = entities.get(e);
            HashMap<String, Object> entityMap = new HashMap<String, Object>();
            entityMap.put("uuid", entity.method_5667().toString());
            entityMap.put("name", entity.method_5477().getString());
            boolean isPlayer = entity.method_31747();
            entityMap.put("isPlayer", isPlayer);
            entityMap.put("type", entity.method_5864().method_5897().getString());
            entityMap.put("x", entity.method_23317() - (double)edPos.method_10263());
            entityMap.put("y", entity.method_23318() - (double)edPos.method_10264());
            entityMap.put("z", entity.method_23321() - (double)edPos.method_10260());
            entityMaps[e] = entityMap;
        }
        return entityMaps;
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public void newEntityEvent(class_1297 entity) {
        class_2338 edPos = this.edTile.method_11016();
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        entityMap.put("uuid", entity.method_5667().toString());
        entityMap.put("name", entity.method_5477().getString());
        boolean isPlayer = entity.method_31747();
        entityMap.put("isPlayer", isPlayer);
        entityMap.put("type", entity.method_5864().method_5897().getString());
        entityMap.put("x", entity.method_23317() - (double)edPos.method_10263());
        entityMap.put("y", entity.method_23318() - (double)edPos.method_10264());
        entityMap.put("z", entity.method_23321() - (double)edPos.method_10260());
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("new_entity", new Object[]{computer.getAttachmentName(), entityMap});
        }
    }

    public void removedEntityEvent(class_1297 entity) {
        class_2338 edPos = this.edTile.method_11016();
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        entityMap.put("uuid", entity.method_5667().toString());
        entityMap.put("name", entity.method_5477().getString());
        boolean isPlayer = entity.method_31747();
        entityMap.put("isPlayer", isPlayer);
        entityMap.put("type", entity.method_5864().method_5897().getString());
        entityMap.put("x", entity.method_23317() - (double)edPos.method_10263());
        entityMap.put("y", entity.method_23318() - (double)edPos.method_10264());
        entityMap.put("z", entity.method_23321() - (double)edPos.method_10260());
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("removed_entity", new Object[]{computer.getAttachmentName(), entityMap});
        }
    }
}

